--
-- Sp_AddPhoneToDNCAndRetireRespondent
--
-- Register a phone to do not call list, if the registration already exist 
-- we refresh the RegistrationDate with the today date ( UTC).Then it right an entrie call in Historic table
--
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_AddPhoneToDNCAndRetireRespondent]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].Sp_AddPhoneToDNCAndRetireRespondent
GO

CREATE PROCEDURE Sp_AddPhoneToDNCAndRetireRespondent
                @projectId     INT,
                @userId        INT,
                @ContextId     INT,
                @ResRespondent VARCHAR(10),
                @Source        VARCHAR(255) = NULL
AS
  SET nocount  ON
    
  DECLARE  @resphone VARCHAR(20)
  SELECT @resphone = resphone
  FROM   respondent
  WHERE  resrespondent = @resrespondent;
  IF ( @resphone IS NOT NULL AND @resphone <> '' )
    BEGIN
            
      EXEC VX_Sp_RegisterPhoneToDNC @resphone, @ContextId, @Source
      
      DECLARE  @DNCResult VARCHAR(5);
      SELECT @DNCResult = Rtrim([value])
      FROM   systemconfig
      WHERE  [name] = 'DoNotCallListResultCode'
      INSERT INTO historic
                 (hisrespondent,
                  hiscallnumber,
                  hisinterviewer,
                  hisresult,
                  hiscalldate,
                  histimeslot,
                  hiscallduration,
                  hisdatatype,
                  hisstartquestion,
                  hisendquestion,
                  hismonitoring,
                  hisdialerline,
                  hiswait,
                  hispause,
                  hisfilereference,
                  hispreviouscalldate,
                  projectid,
                  collectmode)
      SELECT @ResRespondent,
             Coalesce((SELECT Max(hiscallnumber) + 1
                       FROM   historic
                       WHERE  hisrespondent = @resrespondent),1),
             @userId,
             @DNCResult,
             Getutcdate(),
             0,
             0,
             0,
             '',
             '',
             0,
             0,
             0,
             0,
             '',
             (SELECT Max(hiscalldate)
              FROM   historic
              WHERE  hisrespondent = @resrespondent),
             @projectId,
             0
      UPDATE respondent
      SET    rescallbackdate = 0,
             rescall = 1,
             rescallcount = rescallcount + 1,
             rescoderesult = @DNCResult,
             projectid = @projectId,
             modifiedby = @userId,
             modified = Getutcdate()
      WHERE  resrespondent = @resrespondent
      SELECT @DNCRESULT
    END
GO
